<?php

namespace App\Http\Controllers\Services;

use App\Http\Controllers\Controller;
use App\Jobs\SendActivation;
use App\Mail\Verify;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Str;

class Registration extends Controller
{
    /**
     * [Description for generatePassword]
     *
     * @return [random hash string ]
     * 
     */
    public function generatePassword()
    {
        return Hash::make(Str::random(15));
    }

    /**
     * [Description for sendMails]
     *
     * @param mixed $object
     * 
     * @return [boolean]
     * 
     */
    public static function sendMails($user)
    { 
        try {
           $user = User::where('id',$user->id)->get();
            SendActivation::dispatch($user);   
            return true;
        } catch (\Throwable$th) {
            return false;
        }
    }

    /**
     * []
     *
     * @param mixed $email
     * @param mixed $password
     * 
     * @return [view]
     * 
     */
    public function reset($email,$password)
    {
        try {
            $users = User::get();
            foreach ($users as $user ) {
                if (Hash::check($user->email,str_replace('&&','/',$email)) && $user->password == str_replace('&&','/',$password)) {
                    Auth::login($user);
                    return view('auth.reset-password');
                }
            }
            return view('auth.login');
        } catch (\Throwable $th) {
            return view('auth.login')->with(['error'=>'عذرا هناك خطأ ما']);
        }

    }

    /**
     * [This function used to send email to student
     *  to active her account and reset password]
     *
     * @return [type]
     * 
     */
    public static function sendStudentActivation()
    {

       $students =  User::student()->where('is_send_activation',-1)->get()->chunk(5,function($data)
        {
           return $data;
        });

        foreach ($students as $student) {
            SendActivation::dispatch($student);   
        }
    }
    /**
     * [This function used to send email to trainer
     *  to active her account and reset password]
     *
     * @return [type]
     * 
     */
    public static function sendTrainerActivation()
    {

       $students =  User::train()->where('is_send_activation',-1)->get()->chunk(5,function($data)
        {
           return $data;
        });

        foreach ($students as $student) {
            SendActivation::dispatch($student);   
        }
    }

}
